<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ReturnItemsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'order_number'=>$this?->orderItem?->order_id,
            'item_name'=>$this?->orderItem?->product?->name,
            'item_image'=>$this?->orderItem?->product?->thumbnailImage?->file_url,
            'item_qty'=>$this?->orderItem?->qty,
            'item_price'=>$this?->orderItem?->price,
            'item_size'=>$this?->orderItem?->size,
            'item_color'=>$this?->orderItem?->color,
            'customer_note'=>$this?->note,
            'admin_note'=>$this?->note,
            'shop_name'=>$this?->orderItem?->shop?->name,
            'status'=>$this?->status_text,
            'date'=>date('d M Y H:i:s',strtotime($this->created_at))
        ];
    }
}
