<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductDetialsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $data =  [
            'id'=>$this->id,
            'product_name'=>$this->name,
            "category_id"=>$this->category_id,
            "subcategory_id"=>$this->subcategory_id,
            "brand_id"=>$this->brand_id,
            "shop_id"=>$this->shop_id,
            "warranty_time"=>$this->warranty_time,
            "refund_time"=>$this->refund_time,

            'customer_discount'=>$this->customer_discount,
            'original_price'=>$this->original_price,
            'sale_price'=>$this->sale_price,
            'actual_sell_price'=>(int)$this->actual_sell_price,
            'thumbnail_url'=>$this->thumbnailImage?->file_url,

            'delivery_charge_inside_dhaka'=>50,
            'delivery_charge_outside_dhaka'=>100,

            'sizes'=>explode(',',$this->sizes),
            'colors'=>[],
            'stock'=>$this->stock,
            'images'=>$this->images->whereNotNull('image.file_url')->pluck('image.file_url'),

            'shop_name'=>$this?->shop?->name,
            'category_name'=>$this?->category?->name,
            'subcategory_name'=>$this?->subcategory?->name,
            'brand_name'=>$this?->brand?->name,

            'is_free_delivery'=>$this->is_free_delivery,
            'free_delivery_quantity'=>$this->free_delivery_quantity,
            'product_type'=>$this->product_type==1?'mystore':'customer',
            'type'=>$this->product_type == 1?
                    collect(productType())->where('id',$this->type)->value('name'):
                    null,
            'details'=>[]
        ];

        if(auth('sanctum')->check() && !$this->is_free_delivery){
            $data['delivery_charge'] = auth('sanctum')->user()->division_id == 6?50.00:100.00;
        }

        if($this->details_one){
            $data['details'][] = [
                'key'=>'first',
                'tab_name'=>'Details',
                'title' =>$this->details_one_title,
                'description'=>$this->details_one
            ];
        }
        if($this->details_two){
            $data['details'][] = [
                'key'=>'second',
                'tab_name'=>'Specifications',
                'title' =>$this->details_two_title,
                'description'=>$this->details_two
            ];
        }
        if($this->details_three){
            $data['details'][] = [
                'key'=>'third',
                'tab_name'=>'Features',
                'title' =>$this->details_three_title,
                'description'=>$this->details_three
            ];
        }

        $colors = [];
        foreach($this->colors as $color){
            $colors[]=[
                'id'=>$color->id,
                'image_url'=>$color->image_url,
            ];
        }

        $data['colors'] = $colors;

        return $data;
    }
}
