<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductSubcategoryRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }
    public function rules()
    {
        if(request()->has('id')){
            return [
                "category_id" => "required",
                "subcategory_name_en" => "required|unique:tbl_product_subcategory,subcategory_name_en,".request('id'),
                "subcategory_name_bn" => "required|unique:tbl_product_subcategory,subcategory_name_bn,".request('id'),
                "status" => "required",
            ];
        }
        return [
            "category_id" => "required",
            "subcategory_name_en" => "required|unique:tbl_product_subcategory,subcategory_name_en",
            "subcategory_name_bn" => "required|unique:tbl_product_subcategory,subcategory_name_bn",
            "status" => "required",
        ];
    }
}
