<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductBasicRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'category_id'=>'required',
            'subcategory_id'=>'required',
            'brand_id'=>'required',
            'product_name_en'=>'required',
            'product_name_bn'=>'required',
            'company'=>'required',
            'status'=>'required',
            'thumbnail'=>request('id')?'':'required',
            'images'=>request('id')?'':'required',
            'thumbnail.*' => 'image|dimensions:min_width=375,min_height=375,max_width=375,max_height=375',
            'images.*' => 'image|dimensions:min_width=1200,min_height=675,max_width=1200,max_height=675',
        ];
    }
}
