<?php

namespace App\Http\Requests\Hub;

use Illuminate\Foundation\Http\FormRequest;

class WithdrawRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'amount'=>'required|numeric|min:'.HUB_MIN_WITHDRAWAL_BALANCE,
            'payment_method'=>'required',
            'number'=>'required_if:payment_method,Bkash,Nogod',
            'type'=>'required_if:payment_method,Bkash,Nogod',
            'bank_name'=>'required_if:payment_method,Bank',
            'bank_location'=>'required_if:payment_method,Bank',
            'account_number'=>'required_if:payment_method,Bank',
            'account_holder_name'=>'required_if:payment_method,Bank'
        ];
    }
}
