<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DeliveryHubRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }
    public function rules()
    {
        
        if (request()->has("id")) {
            return [
                'email'=>'required',
                'name'=>'required',
                'division'=>'required',
                'district'=>'required',
                'police_station'=>'required',
                'address'=>'required',
                'phone'=>'required',
                'status'=>'required',
                'business_title'=>'required',
                'propiter_name'=>'required',
                'business_division'=>'required',
                'business_district'=>'required',
                'business_police_station'=>'required',
                'business_address'=>'required',
                'business_phone'=>'required',
            ];
        } else {
            return [
                'email'=>'required',
                'password'=>'required|min:8|max:20',
                'profile_photo'=>'required',
                'name'=>'required',
                'division'=>'required',
                'district'=>'required',
                'police_station'=>'required',
                'address'=>'required',
                'phone'=>'required',
                'status'=>'required',
                'logo'=>'required',
                'business_title'=>'required',
                'business_division'=>'required',
                'business_district'=>'required',
                'business_police_station'=>'required',
                'business_address'=>'required',
                'business_phone'=>'required',
                'trade_license'=>'required',
                'nid'=>'required',
            ];
        }
    }
}
