<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BannerRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }
    public function rules()
    {
        if (Request()->has("id")) {
            $data = [
                "type" => "required",
                "link" => "required",
                "status" => "required",
            ];
            if(request()->hasFile('banner_image') && request()->id > 0){
                $data['banner_image']='image|dimensions:max_width=800,max_height=300';
            }

            return $data;
        } else {
            return [
                'banner_image'=>'required|image|dimensions:max_width=800,max_height=300',
                "type" => "required",
                "link" => "required",
                "status" => "required",
            ];
        }
    }
}
