<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class HubAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if(auth('hub')->check() && auth('hub')?->user()?->status == ACTIVE)
            return $next($request);

        return redirect()->route('hub.auth.login.form');

    }
}
