<?php

namespace App\Http\Livewire;

use App\Models\Area;
use App\Models\District;
use App\Models\Division;
use App\Models\Upazila;
use Livewire\Component;

class Location extends Component
{

    public $division_id,$district_id,$upazila_id,$area_name;
    public $districts=[],$upazilas=[];

    protected $listeners = [
        'divisionUpdated' => 'loadDistrict',
        'districtUpdated' => 'loadUpazila'
    ];

    public function loadDistrict($divisionId)
    {
        $this->division_id = $divisionId;
        $this->district_id = null; // Reset district
        $this->upazila_id = null; // Reset upazila
        $this->districts = District::where('division_id',$divisionId)->get();
        // Load districts for the selected division
    }

    public function loadUpazila($districtId)
    {
        $this->district_id = $districtId;
        $this->upazila_id = null; // Reset upazila
        // Load upazilas for the selected district
        $this->upazilas = Upazila::where('district_id',$districtId)->get();
    }

    public function loadData(){
        $id = request('id');
        $area = Area::where('id',$id)->first();
        $this->area_name = $area->area_name;
        $this->division_id = $area->division_id;
        $this->district_id = $area->district_id;
        $this->upazila_id = $area->upazila_id;
        $this->districts = District::where('division_id',$area->division_id)->get();
        $this->upazilas = Upazila::where('district_id',$area->district_id)->get();
    }

    public function render()
    {
        $divisions = Division::get();
        if(request('id')){
            $this->loadData();
        }
        return view('livewire.location',compact('divisions'));
    }
}
