<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Http\Requests\Seller\ProductRequest;
use App\Models\Colors;
use App\Models\Company;
use App\Models\Product;
use App\Models\ProductBasicInfo;
use App\Models\ProductCategory;
use App\Models\ProductImages;
use App\Models\Shop;
use App\Models\Sizes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProductController extends Controller
{
    public function list(){
        $products  = Product::where('user_id',auth('seller')->id())->get();
        return view('seller.product.list',compact('products'));
    }


    public function create(){
        $companies = Company::whereHas('brands')->get();
        $categories = ProductCategory::whereHas('subcategories')->get();
        $sizes = Sizes::all();
        $colors = Colors::all();
        $data=null;
        $subcategories=[];
        $products=[];

        return view("seller.product.form",compact("categories", "companies",'sizes','colors','data','subcategories','products'));
    }


    public function store(ProductRequest $request)
    {
        DB::beginTransaction();
        try {
            $productBasicInfo = ProductBasicInfo::findOrFail($request->product_id);
            $data = [
                'category_id'=>$request->category_id,
                'subcategory_id'=>$request->subcategory_id,
                'company_id'=>$request->company,
                'brand_id'=>$request->brand_id,
                'product_name_en'=>$productBasicInfo->product_name_en,
                'product_name_bn'=>$productBasicInfo->product_name_bn,
                'thumbnail'=>$request->thumbnail,

                "basic_info_id" => $request->product_id,

                "details" => $request->details,
                "original_price" => $request->original_price,
                "sale_price" => $request->sale_price,
                "warranty_time"=>$request->warranty_time,
                "refund_time"=>$request->refund_time,
                "sizes"=>$request->sizes ? implode(',',$request->sizes):'',
                "colors"=>$request->colors ? implode(',',$request->colors):'',
                'stock'=>$request->stock,
                'status'=>2,
            ];

            if ($request->has("id")) {
                Product::where("id", $request->id)->update($data);
                $productId = $request->id;
            } else {
                $data['shop_id'] = auth('seller')->user()?->shop?->id;
                $data['user_id'] = auth('seller')->id();
                $product = Product::create($data);
                $productId = $product->id;
            }

            ProductImages::where('product_id',$productId)->delete();
            $images = json_decode($request->images);
            foreach($images as $image){
                ProductImages::insert([
                    'image_id'=>$image->id,
                    'product_id'=>$productId,
                    'file_path'=>$image->file_path,
                ]);
            }
            DB::commit();
            toastr()->success('Product info has been saved successfully');
            return redirect()->route('seller.product.edit',['id'=>$productId]);
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Product -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Product::where("id", $id)->delete();
        return redirect()->back()->with("success", "Data Deleted Successfully");
    }
}
