<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Http\Requests\Hub\WithdrawRequest;
use App\Models\ComissionWalletHistory;
use App\Models\DeliveryHub;
use App\Models\HubWithdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WithdrawControler extends Controller
{
    public function index(){
        $withdrawals = HubWithdrawal::where('hub_id',auth('hub')->id())->orderBy('id','desc')->get();
        return view('hub.withdraw.index',compact('withdrawals'));
    }

    public function store(WithdrawRequest $withdrawRequest){
        DB::beginTransaction();
        try{
            $data = [
                'number'=>$withdrawRequest->number,
                'type'=>$withdrawRequest->type,
                'bank_name'=>$withdrawRequest->bank_name,
                'bank_location'=>$withdrawRequest->bank_location,
                'account_number'=>$withdrawRequest->account_number,
                'account_holder_name'=>$withdrawRequest->account_holder_name,
            ];

            $deliveryHub  = DeliveryHub::findOrFail(auth('hub')->id());
            if($deliveryHub->commission_balance < $withdrawRequest->amount){
                toastr()->error('Insufficient balance');
                return redirect()->back();
            }

            HubWithdrawal::create([
                'hub_id'=>auth('hub')->id(),
                'payment_method'=>$withdrawRequest->payment_method,
                'amount'=>$withdrawRequest->amount,
                'data'=>$data,
                'admin_reason'=>null,
                'status'=>HUB_WITHDRAW_REQUEST_PENDING,
            ]);

            ComissionWalletHistory::create([
                'hub_id'=>$deliveryHub->id,
                'amount'=>-$withdrawRequest->amount,
                'transaction_type'=>WITHDRAWAL,
                'message'=>number_format($withdrawRequest->amount,2).taka().' has been withdrawn',
            ]);

            $deliveryHub->decrement('commission_balance',$withdrawRequest->amount);
            DB::commit();

            toastr()->success('Withdrwal request has been sent successfully');
            return redirect()->back();
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error('Something went wrong please try again');
            return redirect()->back();
        }




    }
}
