<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Models\ComissionWalletHistory;
use App\Models\DeliveryHub;
use App\Models\FundHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WalletController extends Controller
{
    public function fund(){
        $title = 'FUND BALANCE HISTORY';
        $histories = FundHistory::where('type','FUND')->orderByDesc('id')->get();
        return view('hub.wallet-history.fund',compact('histories','title'));
    }

    public function cod(){
        $title = 'COD BALANCE HISTORY';
        $histories = FundHistory::where('type','COD')->orderByDesc('id')->get();
        return view('hub.wallet-history.fund',compact('histories','title'));
    }

    public function commission(){
        $commissions = ComissionWalletHistory::where('hub_id',auth('hub')->id())->orderByDesc('id')->get();
        return view('hub.wallet-history.commission',compact('commissions'));
    }

    public function transferCodToFund(Request $request){
        $request->validate(['amount'=>'required|numeric']);
        DB::beginTransaction();

        try{
            $deliveryHub = DeliveryHub::where('id',auth('hub')->id())->firstOrFail();
            if($deliveryHub->cod_balance < $request->amount){
                toastr()->error('Insufficient balance');
                return redirect()->back();
            }
            $deliveryHub->cod_balance -= $request->amount;
            $deliveryHub->fund_balance += $request->amount;
            $deliveryHub->save();

            FundHistory::insert([
                [
                    'hub_id'=>$deliveryHub->id,
                    'amount'=>-$request->amount,
                    'type'=>'COD',
                    'message'=>$request->amount.taka().' has been transferred to your fund',
                    'created_at'=>Carbon::now(),
                    'updated_at'=>Carbon::now()
                ],
                [
                    'hub_id'=>$deliveryHub->id,
                    'amount'=>$request->amount,
                    'type'=>'FUND',
                    'message'=>$request->amount.taka().' has been credited from your COD balance',
                    'created_at'=>Carbon::now(),
                    'updated_at'=>Carbon::now()
                ]
            ]);

            DB::commit();

            toastr()->success('COD amount has been transferred successfully');
            return redirect()->back();
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error($e->getMessage());
            return redirect()->back();
        }
    }
    public function transferCommissionToFund(Request $request){
        $request->validate(['amount'=>'required|numeric']);
        DB::beginTransaction();

        try{
            $deliveryHub = DeliveryHub::where('id',auth('hub')->id())->firstOrFail();
            if($deliveryHub->commission_balance < $request->amount){
                toastr()->error('Insufficient balance');
                return redirect()->back();
            }
            $deliveryHub->commission_balance -= $request->amount;
            $deliveryHub->fund_balance += $request->amount;
            $deliveryHub->save();

            FundHistory::create([
                'hub_id'=>$deliveryHub->id,
                'amount'=>$request->amount,
                'type'=>'FUND',
                'message'=>$request->amount.taka().' has been credited from your COD balance',
            ]);

            ComissionWalletHistory::create([
                'hub_id'=>$deliveryHub->id,
                'amount'=>-$request->amount,
                'transaction_type'=>FUND_TRANSFER,
                'message'=>$request->amount.taka().' has been transferred to your fund',
            ]);

            DB::commit();

            toastr()->success('Comission Amount has been transferred successfully');
            return redirect()->back();
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error($e->getMessage());
            return redirect()->back();
        }
    }
}
