<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderItemHistory;
use App\Models\OrderItems;
use App\Models\OrderStatusHistory;
use App\Services\OrderService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    public function index(){
        return view('hub.order.index');
    }

    public function orders(){
        $orders = Order::where('hub_id',auth('hub_id'))->where('order_type','mystore')->orderBy('id','desc')->get();
        return view('hub.order.list',compact('orders'));
    }

    public function details(){
        $order = Order::where('order_number',request('order_number'))->first();
        if($order){
            return view('hub.order.details',compact('order'));
        }else{
            toastr()->error('Sorry ! No Order Found With This Order Number');
            return redirect()->back();
        }
    }

    public function myStoreOrder(){
        $orders = Order::where('hub_id',auth('hub')->id())->where('order_type','mystore')->orderBy('id','desc')->get();
        return view('hub.order.mystore',compact('orders'));
    }


    public function changeStatus($order_id,$status){
        DB::beginTransaction();
        try{
            $orderService = new OrderService();
            $order = Order::with('user')->findOrFail($order_id);

            if($status == ORDER_ACCEPTED && $order->payment_method == 'COD'){
                if($order->hub?->fund_balance < $order->total){
                    flash()->error('Sorry , You dont have enough fund to accept this order');
                    return redirect()->back();
                }
                $orderService->chargeFromFund($order);
            }


            $order->update(['status'=>$status]);
            $orderService->writeStatusLog($order->id,$status,auth('hub')->user());


            if($status == ORDER_DELIVERED && !$order->is_comission_shared){
                $orderService->shareComission($order);
            }

            if($status == ORDER_DELIVERED){
                $setPackage = $orderService->setUserPackage($order);
                if(!$setPackage){
                    flash()->error('Sorry ! Package Id Not Found');
                }

                $orderService->setRefundTime($order->id);
                $orderService->transferToCODWallet($order);
                $orderService->transferDeliveryComission($order);
            }


            $orderService->sendNotification($order);


            DB::commit();
            flash()->success("Order status changed successfully");
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }


     public function changeItemStatus(Request $request,$order_item_id){
        DB::beginTransaction();
        try{
            $request->validate([
                'status'=>'required',
                'note'=>'required'
            ]);
            $orderItem = OrderItems::where('id',$order_item_id)->first();
            if(!$orderItem){
                abort(404);
            }
            $orderItem->update(['status'=>$request->status]);
            $data = [
                'order_id'=>$orderItem->order_id,
                'order_item_id'=>$orderItem->id,
                'product_id'=>$orderItem->product_id,
                'status'=>$request->status,
                'note'=>$request->note,
                'hub_id'=>$orderItem->hub_id
            ];


            OrderItemHistory::updateOrCreate(['order_item_id'=>$orderItem->id],$data);
            DB::commit();
            flash()->success('Order Item Status Changed Successfully');
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }

    public function orderDelivered($id){
        $order = Order::where('id',$id)->where('hub_id',auth('hub')->id())->first();
        if(!$order){
            flash()->error('Sorry, Order Not Found');
        }
    }
}
