<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Models\FundRequest;
use Illuminate\Http\Request;
use Symfony\Component\VarDumper\Caster\RedisCaster;

class FundController extends Controller
{
    public function index(){
        $requests = FundRequest::stockistFilter()->get();
        return view('hub.fund.index', compact('requests'));
    }

    public function create(){
        return view('hub.fund.form',['request'=>null]);
    }

    public function edit($id){
        $request = FundRequest::where('status',FUND_REQUEST_PENDING)->findOrFail($id);
        return view('hub.fund.form',compact('request'));
    }

    public function store(Request $request){
        $id = $request->get('id');
        $data = [
            'amount' => $request->amount,
            'description' => $request->description,
            'type' => 'stockist',
            'hub_id' => auth('hub')->id(),  // Assuming Hub ID is stored in user's session
            'status' => FUND_REQUEST_PENDING
        ];
        FundRequest::updateOrCreate(['id'=>$id,'status'=>FUND_REQUEST_PENDING],$data);
        return redirect()->back()->with('success','Fund request submitted successfully');
    }

    public function delete($id){
        $request = FundRequest::where('status',FUND_REQUEST_PENDING)->findOrFail($id);
        $request->delete();

        return redirect()->back();
    }
}
