<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Http\Requests\Hub\LoginRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function loginForm(){
        return view('hub.auth.login');
    }

    public function login(LoginRequest $request){
        $auth = Auth::guard('hub')->attempt(['email'=>$request->email,'password'=>$request->password,'status'=>ACTIVE]);
        if($auth){
            toastr()->success('Welcome to the deller panel');
            return redirect()->route('hub.dashboard.index');
        }else{
            toastr()->error('Sorry ! invalid email or password');
            return redirect()->back();
        }
    }


    public function logout(){
        auth('hub')->logout();
        return redirect()->route('hub.auth.login.form');
    }
}
