<?php

namespace App\Http\Controllers\Deller;

use App\Http\Controllers\Controller;
use App\Http\Requests\Deller\LoginRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function loginForm(){
        return view('deller.auth.login');
    }

    public function login(LoginRequest $request){
        $auth = Auth::guard('deller')->attempt(['email'=>$request->email,'password'=>$request->password,'role'=>DELLER,'status'=>ACTIVE]);
        if($auth){
            toastr()->success('Welcome to the deller panel');
            return redirect()->route('deller.dashboard.index');
        }else{
            toastr()->error('Sorry ! invalid email or password');
            return redirect()->back();
        }
    }


    public function logout(){
        auth('deller')->logout();
        return redirect()->route('deller.auth.login.form');
    }
}
