<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\ForgotPasswordOtpRequest;
use App\Http\Requests\Api\ForgotPasswordRequest;
use App\Http\Requests\Api\ResetPasswordRequest;
use App\Mail\ForgotPasswordMail;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class ForgotPasswordController extends Controller
{
    public function sendOtp(ForgotPasswordRequest $forgotPasswordRequest){
        $user = User::where('status',1)->where(function($query)use($forgotPasswordRequest){
            $query->where('email', $forgotPasswordRequest->phoneOrEmail)
                ->orWhere('phone', $forgotPasswordRequest->phoneOrEmail);
        })->first();
        if(!$user){
            return response()->json([
               'message' => "Sorry , we didn't found any account with this email/phone",
            ], 404);
        }
        $otp = str_pad(rand(10000, 99999), 5, '0', STR_PAD_LEFT);
        $user->otp = $otp;
        $user->save();

        if($forgotPasswordRequest->phoneOrEmail == $user->email){
            //send otp in email
            Mail::to($user->email)->send(new ForgotPasswordMail($user->name,$otp));
        }
        if($forgotPasswordRequest->phoneOrEmail == $user->phone){
            //send otp in phone
            $message = "Your OTP for resetting your password is : ".$otp;
            Notification::sendSms($message,$user->phone);
        }

        return response()->json([
           'message' => "We sent OTP to your registered email/phone number.",
           'id'=>$user->id,
        ], 200);

    }

    public function verifyOtp(ForgotPasswordOtpRequest $forgotPasswordOtpRequest){
        $user = User::where('status',1)->find($forgotPasswordOtpRequest->id);

        if(!$user){
            return response()->json([
               'message' => "Sorry , we didn't found any account with this email/phone",
            ], 404);
        }
        if($user->otp !== $forgotPasswordOtpRequest->otp){
            return response()->json([
               'message' => "The Otp You have entered is incorrect",
            ], 409);
        }

        return response()->json([
            'message' => "Veirifcation done successfully",
        ], 200);
    }

    public function resetPassword(ResetPasswordRequest $resetPasswordRequest){
        $user = User::where('status',1)->where('otp',$resetPasswordRequest->otp)->find($resetPasswordRequest->id);

        if(!$user){
            return response()->json([
                'message' => "Sorry , we didn't found any account with this email/phone",
            ], 404);
        }

        $user->update([
            'password' => Hash::make($resetPasswordRequest->password)
        ]);

        return response()->json([
            'message' => "Your password has been reseted successfully",
        ], 200);
    }

    public function test(){
        Mail::to('22moynulislam22@gmail.com')->send(new ForgotPasswordMail('Moynul',12345));
        return 'sent';
    }
}
