<?php

namespace App\Http\Controllers;

use App\Models\AppSettings;
use App\Models\Comission;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;

class AppSettingsController extends Controller
{
    public function index(){
        $settings = AppSettings::get();
        return view('admin.app-settings.index',compact('settings'));
    }

    public function update(Request $request){
        $allFilds = $request->except('_token');
        foreach($allFilds as $field=>$value){
            AppSettings::where('tag',$field)->update(['value'=>$value]);
        }

        AppSettings::where('tag','comission_status')->update(['value'=>(int)$request->comission_status]);
        AppSettings::where('tag','sms_status')->update(['value'=>(int)$request->sms_status]);

        toastr()->success('App setting has been changed successfully');
        return redirect()->back();
    }

    public function comission(){
        $comissionLevel = AppSettings::where('tag','comission_level')->value('value');
        $conditinalComissions = Comission::get()->where('type','conditional')->pluck('comission','level');
        $unconditinalComissions = Comission::get()->where('type','unconditional')->pluck('comission','level');
        return view('admin.app-settings.comission',compact('comissionLevel','conditinalComissions','unconditinalComissions'));
    }

    public function updateComission(Request $request){
        $allFields = $request->except('_token','type');
        $type = request('type');
        $totalPercentage = 0;
        foreach($allFields as $field=>$value){
            $totalPercentage += (float)$value;
        }

        if($totalPercentage>100){
            toastr()->error("Total comission can't be more than 100%");
            return redirect()->back();
        }
        foreach($allFields as $field=>$value){
            Comission::updateOrCreate(['level'=>$field,'type'=>$type],[
                'level'=>$field,
                'comission'=>$value,
                'type'=>$type
            ]);
        }

        toastr()->success('Comission has been changed successfully');
        return redirect()->back();
    }
}
