<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\UpgradeLeadershipRequest;
use App\Models\ComissionWalletHistory;
use App\Models\LeadershipLevel;
use App\Models\User;
use App\Services\WalletService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LeadershipController extends Controller
{
    public function list(){
        $levels = LeadershipLevel::get();
        return response()->json([
            'levels'=>$levels,
            'current_level'=>auth()->user()->leadership_level ?? 0,
            'current_comission_balance'=>(float)auth()->user()->comission_wallet,
        ],200);
    }


    public function upgrade(UpgradeLeadershipRequest $upgradeLeadershipRequest){
        try{
            DB::beginTransaction();
            $level = LeadershipLevel::find($upgradeLeadershipRequest->id);
            $user = User::find(auth()->id());
            $walletService = new WalletService();

            if($user->leadership_level == $level->level){
                return response()->json(['message'=>'You are already at this level'],500);
            }

            if($level->price > auth()->user()->comission_wallet){
                return response()->json(['message'=>'Insufficient balance'],500);
            }

            $user->update(['leadership_level'=>$level->level,]);
            $message = 'Leadership level upgraded to level '.$level->level;
            $walletService->deductFromUserComission($user,$level->price,1,'LEADERSHIP_UPGRADE',$message);
            $walletService->sendComissionToFlashWallet(null,$level->price,$message,'LEADERSHIP_UPGRADE',$user->id);

            DB::commit();

            return response()->json([
                'success'=>true,
                'message'=>'Level has been upgraded successfully',
                'current_level'=>$user->leadership_level ?? 0,
                'current_comission_balance'=>(float)$user->comission_wallet,
            ],200);
        }catch(\Exception $e){
            return response()->json(['message'=>$e->getMessage()],500);
        }
    }
}
