<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use App\Http\Resources\Agent\DellerResource;
use App\Models\User;
use Illuminate\Http\Request;

class DellerController extends Controller
{
    public function dellers(){
        $dellers = User::where('role',DELLER)->where('status',ACTIVE)->withWhereHas('shop')->whereHas('shop.products')->paginate(20);
        return response()->json([
            'data'=>DellerResource::collection($dellers)
        ]);
    }
}
