<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\CashWalletHistory;
use App\Models\ComissionWalletHistory;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function customer(){
        $data=User::filter()->where('role',CUSTOMER)->paginate(20);
        return view('admin.user.customer',compact('data'));
    }

    public function seller(){
        $data=User::with(['seller'])->where('role',SELLER)->first();
        return view('admin.user.seller',compact('data'));
    }

    public function deller(){
        $data=User::where('role',DELLER)->first();
        return view('admin.user.customer',compact('data'));
    }

    public function agent(){
        $data=User::filter()->where('role',AGENT)->get();
        return view('admin.user.agent',compact('data'));
    }

    public function changeStatus($user_id,$status){
        User::where('id',$user_id)->update(['status'=>$status]);
        return redirect()->back()->with('success','Status has been changed successfully');
    }

    public function delete($user_id){
        User::where('id',$user_id)->update(['deleted_at'=>Carbon::now()]);
        return redirect()->back()->with('success','Account has been deleted successfully');
    }


    public function transactionHistory(){

    }

    public function getReferrals($id){
        $level = 1;
        $userId = [$id];
        $referralChain = collect();
        $user=User::where('id',$id)->first();

        for ($i = 1; $i < 25; $i++) {
            $users = User::select('id','first_name','last_name','phone','parent_id')->whereIn('parent_id',$userId)->where('role',CUSTOMER)->get();
            if ($users->isEmpty()) {
                break; // Break the loop if no users found at this level
            }

            $level = [
                'label'=>'Level '.$i,
                'users'=>$users
            ];

            $referralChain->push($level);

            $userId = $users->pluck('id')->toArray();
        }

        return view('admin.user.referrals',compact('referralChain','user'));
    }

    public function getTransactions($id){
        $cashWalletTransactions = CashWalletHistory::where('user_id',$id)->orderBy('updated_at','desc')->get();
        $comissionWalletHistory = ComissionWalletHistory::where('user_id',$id)->orderBy('updated_at','desc')->get();
        $user = User::where('id',$id)->first();
        return view('admin.user.transaction',compact('cashWalletTransactions','comissionWalletHistory','user'));
    }

    // public functio
}
