<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\SizesRequest;
use App\Models\Sizes;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;

class SizesController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Sizes();
    }
    public function create()
    {
        $listData = $this->list();
        return view("admin.size.store", compact("listData"));
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = Sizes::filter()->orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return $data;
    }
    public function edit($id)
    {
        $data = Sizes::where("id", $id)->first();
        $listData = $this->list();
        return view("admin.sizes.edit", compact("data", "listData"));
    }
    public function view($id)
    {
        $data = Sizes::where("id", $id)->first();
        return view("admin.sizes.view", compact("data"));
    }

    public function store(SizesRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = ["size_name" => $request->size_name];
            if ($request->has("id")) {
                Sizes::where("id", $request->id)->update($data);
                $text = "updated";
            } else {
                Sizes::insert($data);
                $text = "created";
            }
            DB::commit();
            return redirect()
                ->back()
                ->with("success", "sizes has been " . $text . " successfully");
        } catch (\Exception $e) {
            DB::rollback();
            Log::error("Sizes -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Sizes::find($id)->delete();
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
