<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Shop;
use App\Models\User;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function customerSalesReport(){
        $customers = User::where('role',CUSTOMER)->where('status',ACTIVE)->get();
        $shops = Shop::where('status',ACTIVE)->get();
        // if(request('user_id')){
            $data = Order::selectRaw("
                DATE(created_at) as date,
                COUNT(CASE WHEN status = 6 THEN 1 END) as delivered_orders,
                COUNT(CASE WHEN status = 9 THEN 1 END) as cancelled_orders,
                COUNT(CASE WHEN status NOT IN (6, 9) THEN 1 END) as other_orders,
                COUNT(*) as total_orders,
                SUM(CASE WHEN status = 6 THEN (order_total + tax + delivery_charge) - discount_amount ELSE 0 END) as delivered_orders_total,
                SUM(CASE WHEN status = 9 THEN (order_total + tax + delivery_charge) - discount_amount ELSE 0 END) as cancelled_orders_total
            ")->salesReportfilter()->groupBy('date')->get();
        // }else{
        //     $data = null;
        // }
        return view('admin.reports.customer-sales-report',compact('customers','shops','data'));
    }

    public function store(){}
}
