<?php
namespace App\Http\Controllers\admin;

use App\Http\Requests\ProductSubcategoryRequest;
use App\Models\ProductCategory;
use App\Models\ProductSubcategory;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use DB;

class ProductSubcategoryController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new ProductSubcategory();
    }
    public function create()
    {
        $categories = ProductCategory::get();
        return view("admin.product-subcategory.store", compact("categories"));
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = ProductSubcategory::filter()->orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.product-subcategory.list", compact("data"));
    }
    public function edit($id)
    {
        $categories = ProductCategory::get();
        $data = ProductSubcategory::where("id", $id)->first();
        return view(
            "admin.product-subcategory.store",
            compact("data", "categories")
        );
    }
    public function view($id)
    {
        $data = ProductSubcategory::where("id", $id)->first();
        return view("admin.product-subcategory.view", compact("data"));
    }

    public function store(ProductSubcategoryRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "category_id" => $request->category_id,
                "subcategory_name_en" => $request->subcategory_name_en,
                "subcategory_name_bn" => $request->subcategory_name_bn,
                "subcategory_image" => $request->subcategory_image,
                "status" => $request->status,
            ];
            if ($request->has("id")) {
                ProductSubcategory::where("id", $request->id)->update($data);
                $text = "updated";
            } else {
                ProductSubcategory::insert($data);
                $text = "created";
            }
            DB::commit();
            return redirect()
                ->back()
                ->with(
                    "success",
                    "product_subcategory has been " . $text . " successfully"
                );
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Productsubcategory -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        ProductSubcategory::where("id", $id)->update([
            "deleted_at" => Carbon::now(),
        ]);
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
