<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\OrderItems;
use App\Models\OrderStatusHistory;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\OrderItemHistory;
use App\Services\OrderService;
use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{

    public function list(){
        $orders = Order::filter()->orderBy('id','desc')->get();
        return view('admin.order.list',compact('orders'));
    }

    public function view($id){
        $order = Order::where('id',$id)->first();
        return view('admin.order.view',compact('order'));
    }

    public function changeItemStatus(Request $request,$order_item_id){
        DB::beginTransaction();
        try{
            $request->validate([
                'status'=>'required',
                'note'=>'required'
            ]);
            $orderItem = OrderItems::where('id',$order_item_id)->first();
            if(!$orderItem){
                abort(404);
            }
            $orderItem->update(['status'=>$request->status]);
            $data = [
                'order_id'=>$orderItem->order_id,
                'order_item_id'=>$orderItem->id,
                'product_id'=>$orderItem->product_id,
                'status'=>$request->status,
                'note'=>$request->note,
                'hub_id'=>$orderItem->hub_id
            ];


            OrderItemHistory::updateOrCreate(['order_item_id'=>$orderItem->id],$data);
            DB::commit();
            flash()->success('Order Item Status Changed Successfully');
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }

    public function changeOrderStatus($order_id,$status){
        DB::beginTransaction();
        try{
            $orderService = new OrderService();
            $order = Order::with('user')->findOrFail($order_id);

            if($status == ORDER_REACHED_IN_DELIVERY_HUB){
                $orderItems = OrderItems::where('order_id',$order_id)->where('status',REACHED_AT_LOCAL_HUB)->first();
                if($orderItems){
                    flash()->warning("Not all items reached in delivery hub");
                    return redirect()->back();
                }
            }

            $order->update(['status'=>$status]);
            $orderService->writeStatusLog($order->id,$status,auth('hub')->user());


            if($status == ORDER_DELIVERED && !$order->is_comission_shared){
                $orderService->shareComission($order);
            }

            if($status == ORDER_DELIVERED){
                $setPackage = $orderService->setUserPackage($order);
                if(!$setPackage){
                    flash()->error('Sorry ! Package Id Not Found');
                }

                $orderService->setRefundTime($order->id);
                $orderService->transferToCODWallet($order);
                $orderService->transferDeliveryComission($order);
            }


            $orderService->sendNotification($order);


            DB::commit();
            flash()->success("Order status changed successfully");
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }
}
