<?php

namespace App\Http\Controllers\Admin\MyStore;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StockistAreaRequest;
use App\Models\Area;
use App\Models\DeliveryHub;
use App\Models\Division;
use App\Models\StockistArea;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockistAreaController extends Controller
{
    public function index(){
        $locations = Area::get();
        return view('admin.my-store.location.index',compact('locations'));
    }

    public function create(){
        $divisions = Division::get();
        return view('admin.my-store.location.form',['divisions'=>$divisions,'location'=>null]);
    }

    public function edit($id){
        $divisions = Division::get();
        $location = Area::where('id',$id)->firstOrFail();
        return view('admin.my-store.location.form',compact('location', 'divisions'));
    }

    public function delete($id){
        Area::where('id',$id)->delete();
        toastr()->success('Stockist Area deleted successfully');
        return redirect()->back();
    }

    public function store(StockistAreaRequest $stockistAreaRequest){
        $id= request('id');
        $data = [
            'hub_id'=>$stockistAreaRequest->id,
            'division_id'=>$stockistAreaRequest->division_id,
            'district_id'=>$stockistAreaRequest->district_id,
            'upazila_id'=>$stockistAreaRequest->upazila_id,
            'area_name'=>$stockistAreaRequest->area_name,
        ];

        Area::updateOrCreate(['id'=>$id],$data);
        toastr()->success('Stockist area has been saved successfully');
        return redirect()->route('admin.mystore.location.index');
    }


    public function stockist(){
        $stockists =  DeliveryHub::where('is_stockist',1)->get();
        return view('admin.my-store.location.stockist',compact('stockists'));
    }

    public function assign($hubId){
        $hub = DeliveryHub::where('id',$hubId)->where('is_stockist',1)->with(['stockistAreas.area','stockistAreas.area.division','stockistAreas.area.district','stockistAreas.area.upazila'])->firstOrFail();
        $areas = Area::get();
        return view('admin.my-store.location.assign-area',compact('hub','areas'));
    }

    public function assignStore($id, Request $request){
        $this->validate($request,['area_ids'=>'required']);
        DB::beginTransaction();
        $areas = [];
        StockistArea::where('hub_id',operator: $id)->delete();
        foreach($request->area_ids as $area_id){
            $areas[] = [
                'hub_id'=>$id,
                'area_id'=>$area_id,
            ];
        }

        StockistArea::insert($areas);
        DB::commit();

        toastr()->success('Location has been assigned successfully');
        return redirect()->back();
    }
}
