<?php

namespace App\Http\Controllers\Admin\MyStore;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProductRequest;
use App\Models\Colors;
use App\Models\Company;
use App\Models\Package;
use App\Models\Product;
use App\Models\ProductBasicInfo;
use App\Models\ProductCategory;
use App\Models\ProductColor;
use App\Models\ProductImages;
use App\Models\ProductSubcategory;
use App\Models\Sizes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProductController extends Controller
{
    public function index(){
        $products = Product::filter()->where('product_type',1)->orderByDesc("id")->withWhereHas('basicInfo')->get();
        return view('admin.my-store.product.index',compact('products'));
    }

    public function create(){
        $companies = Company::whereHas('brands')->get();
        $categories = ProductCategory::whereHas('basicProducts')->get();
        $products = ProductBasicInfo::with('thumbnails')->where('status',1)->whereNull('deleted_at')->get();
        $packages = Package::get();
        $sizes = Sizes::all();
        $colors = Colors::all();
        $data=null;
        $subcategories=[];

        return view("admin.my-store.product.form",compact("categories", "companies",'sizes','colors','data','subcategories','products','packages'));
    }

     public function edit($id)
    {
        $data = Product::filter()->where('product_type',1)->with(['thumbnailImage','images.image','colors'])->findOrFail($id);
        if(!$data){
            abort(404);
        }
        // $role = $data->user->role;
        $companies = Company::whereHas('brands')->get();
        $categories = ProductCategory::whereHas('basicProducts')->get();
        $subcategories = ProductSubcategory::where('category_id',$data->category_id)->get();
        $products=[];

        $selctedImages  = $data->images?->map(function($image){
            return [
                'id'=>$image->id,
                'file_url'=>$image?->image?->file_url,
                'file_path'=>$image?->image?->file_path
            ];
        });

        $data->_images = $selctedImages;


        $sizes = Sizes::all();
        $selectedColors = $data->colors?->pluck('color_id')->toArray();
        $colors = Colors::whereNotIn('id',$selectedColors)->get();
        $basicInfo = ProductBasicInfo::where('id',$data->basic_info_id)->first();
        $packages = Package::get();

        return view(
            "admin.my-store.product.form",
            compact("data", "categories","companies","subcategories","sizes","colors","basicInfo","data","products","packages")
        );
    }

    public function store(ProductRequest $request)
    {
        DB::beginTransaction();
        try {
            // $isExist = Product::filter()->where('basic_info_id',$basic_info_id)->where('shop_id',$request->shop_id)->first();
            // if($isExist && !$request->id){
            //     toastr()->warning('This shop already has this  product');
            //     return redirect()->back();
            // }
            // $user_id = Shop::where('id',$request->shop_id)->value('user_id');
            $productBasicInfo = ProductBasicInfo::where('id',$request->product_id)->first();
            if(request()->has('id')){
                $comission = (float)$request->spot_comission +  $request->team_comission;
                if($comission > 100){
                    toastr()->error("Comission can't be set more than 100%");
                    return redirect()->back();
                }
            }
            $data = [
                'category_id'=>$request->category_id,
                'subcategory_id'=>$request->subcategory_id,
                'company_id'=>$request->company,
                'brand_id'=>$request->brand_id,
                'product_name_en'=>$productBasicInfo->product_name_en,
                'product_name_bn'=>$productBasicInfo->product_name_bn,
                'thumbnail'=>$request->thumbnail,

                "basic_info_id" => $request->product_id,

                "original_price" => $request->original_price,
                "sale_price" => $request->sale_price,
                "warranty_time"=>$request->warranty_time,
                "refund_time"=>$request->refund_time,
                "customer_discount"=> $request->customer_discount,
                "agent_discount" => $request->agent_discount,

                "spot_comission"=>$request->spot_comission,
                "team_comission"=>$request->team_comission,
                "leadership_comission"=>$request->leadership_comission,
                "sponsor_royalti_comission"=>$request->sponsor_royalti_comission,

                "is_featured"=>$request->is_featured,
                "show_in_home"=>$request->show_in_home,
                "status" => $request->status,
                'stock'=>$request->stock,

                'is_free_delivery'=>$request->is_free_delivery=='on'?1:0,
                'free_delivery_quantity'=>$request->free_delivery_quantity,
                'tag'=>$request->tag,

                'details_one_title'=>$request->details_one_title,
                'details_two_title'=>$request->details_two_title,
                'details_three_title'=>$request->details_three_title,

                'details_one'=>$request->details_one,
                'details_two'=>$request->details_two,
                'details_three'=>$request->details_three,

                'type'=>$request->type,
                'package_id'=>$request->package_id,
                'is_cod_allowed'=>(int)$request->is_cod_allowed,
                'product_type'=>1,
            ];

            if ($request->has("id")) {
                Product::where("id", $request->id)->update($data);
                $productId = $request->id;
            } else {
                $data['shop_id'] = 1;
                $product = Product::create($data);
                $productId = $product->id;
            }

            ProductImages::where('product_id',$productId)->delete();
            if($request->images){
                $images = json_decode($request->images);
                foreach($images as $image){
                    ProductImages::insert([
                        'image_id'=>$image->id,
                        'product_id'=>$productId,
                    ]);
                }
            }

            DB::commit();
            toastr()->success('Product info has been saved successfully');
            return redirect()->route('admin.mystore.product.edit',['id'=>$productId]);
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Product -> store : " . $e->getMessage());
            return serverError();
        }
    }
}
