<?php

namespace App\Http\Controllers\Admin\MyStore;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PackageRequest;
use App\Models\Package;
use Illuminate\Http\Request;

class PackageController extends Controller
{
     public function index(){
        $packages = Package::get();
        return view('admin.my-store.package.index',compact('packages'));
    }

    public function create(){
        return view('admin.my-store.package.form',['package'=>null]);
    }

    public function edit($id){
        $package = Package::where('id',$id)->firstOrFail();
        return view('admin.my-store.package.form',compact('package'));
    }

    public function delete($id){
        Package::where('id',$id)->delete();
        toastr()->success('Package deleted successfully');
        return redirect()->back();
    }

    public function store(PackageRequest $packageRequest){
        $id= request('id');
        $data = [
            'name'=>$packageRequest->name,
            'price'=>$packageRequest->price,
            'tsc'=>$packageRequest->tsc,
            'daily_income'=>$packageRequest->daily_income,
        ];

        Package::updateOrCreate(['id'=>$id],$data);
        toastr()->success('Stockist area has been saved successfully');
        return redirect()->route('admin.mystore.package.index');
    }
}
