<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\FlashWalletWithdrawRequest;
use App\Models\ComissionWalletHistory;
use App\Models\FlashWallet;
use App\Models\FlashWalletHistory;
use App\Models\FundHistory;
use App\Models\User;
use App\Services\WalletService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FlashWalletController extends Controller
{
    public function transaction($type){
        $histories = FlashWalletHistory::where('type',$type)->where('amount','>',0)->orderByDesc('id')->paginate(10);
        $total = WalletService::getTotal($type);
        return view('admin.flash-wallet.transaction',compact('histories','total'));
    }

    public function withdrawal($type){
        $histories = FlashWalletHistory::where('type',$type)->where('amount','<',0)->orderByDesc('id')->paginate(10);
        $total = WalletService::getTotal($type);
        return view('admin.flash-wallet.transaction',compact('histories','total'));
    }


    public function withdrawForm($type){
        $total = WalletService::getTotal($type);
        return view('admin.flash-wallet.withdraw-form',compact('total'));
    }

    public function withdrawAmount($type,FlashWalletWithdrawRequest $flashWalletWithdrawRequest){
        DB::beginTransaction();
        try{
            $fieldName = flashWalletTypes()[$type];
            $flashWallet = FlashWallet::first();
            if($flashWallet[$fieldName] < $flashWalletWithdrawRequest->amount){
                toastr()->error('You don\'t have enough balance');
                return redirect()->back();
            }

            $flashWallet->decrement($fieldName,$flashWalletWithdrawRequest->amount);

            FlashWalletHistory::create([
                'amount'=>-$flashWalletWithdrawRequest->amount,
                'type'=>$type,
                'message'=>formatAmount($flashWalletWithdrawRequest->amount).' Has been withdrawn',
                'current_balance'=>$flashWallet[$fieldName]
            ]);

            DB::commit();

            return redirect()->route('admin.flash-wallet.withdrawal',['type'=>$type]);
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error($e->getMessage());
            return redirect()->back();
        }
    }


    public function sponsorRoyaltiTransaction(){
        $histories = ComissionWalletHistory::where('type','SPONSOR_ROYALTI')->where('amount','>',0)->orderByDesc('id')->paginate(10);
        $total['total_income_amount'] = ComissionWalletHistory::where('type','SPONSOR_ROYALTI')->where('amount','>',0)->sum('amount');
        $total['current_balance'] = User::sum('sponsor_royalti_wallet');
        $total['total_withdrawal_amount'] = FundHistory::where('type','SPONSOR_ROYALTI')->sum('amount');
        return view('admin.flash-wallet.transaction',compact('histories','total'));
    }

    public function capableSponsorsRoyaltiUsers(){
        $users = User::withCount('sponsorRoyalti')->where('status',1)->havingRaw('sponsor_royalti_count > ?', [1])->get();
        $total = WalletService::getTotal('SPONSOR_ROYALTI');
        return view('admin.flash-wallet.capable-sponsors-royalti-users',compact('users','total'));
    }

    public function distributeSponsorRoyalti (){
        DB::beginTransaction();
        try{
            $sponsorRoyaltiWalletAmount = FundHistory::first();
            $distributeAmount =  $sponsorRoyaltiWalletAmount->sponsor_royalti_commission;
            if(!$distributeAmount){
                toastr()->error('Insufficient Balance');
                return redirect()->back();
            }

            $users = User::withCount('sponsorRoyalti')->where('status',1) ->havingRaw('sponsor_royalti_count > ?', [1])->get();
            $totalCapableUsers = $users->count();
            $perUserComission = $distributeAmount/$totalCapableUsers;
            foreach($users as $user){
                $user->increment('comission_wallet',$perUserComission);
                ComissionWalletHistory::create([
                    'user_id'=>$user->id,
                    'amount'=>$perUserComission,
                    'type'=>'SPONSOR_ROYALTI',
                    'message'=> formatAmount($perUserComission).' Sponsor Royalti has been received',
                    'current_balance'=>$user->comission_walletcomission_wallet
                ]);
            }


            $sponsorRoyaltiWalletAmount->decrement('sponsor_royalti_commission',$distributeAmount);
            FundHistory::create([
                'amount'=>-$distributeAmount,
                'type'=>'SPONSOR_ROYALTI',
                'message'=>formatAmount($distributeAmount).' Sponsor Royalti has been distributed',
                'current_balance'=>$sponsorRoyaltiWalletAmount->sponsor_royalti_wallet
            ]);
            DB::commit();

            toastr()->error('Sponsor Royalti has been distributed successfully');
            return redirect()->back();
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error($e->getMessage());
            return redirect()->back();
        }
    }
}
