<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\DeliveryHub;
use App\Models\Order;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductSubcategory;
use App\Models\ReturnedItem;
use App\Models\User;
use App\Models\Withdrawal;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(){
        $totalCustomer = User::filter()->where('role',CUSTOMER)->where('status',ACTIVE)->count();
        $totalSeller = User::filter()->where('role',SELLER)->where('status',ACTIVE)->count();
        $totalDeller = User::filter()->where('role',DELLER)->where('status',ACTIVE)->count();
        $totalAgent = User::filter()->where('role',AGENT)->where('status',ACTIVE)->count();
        $totalDeliveryHub = DeliveryHub::where('status',ACTIVE)->count();
        $totalCategory = ProductCategory::where('status',ACTIVE)->count();
        $totalSubCategory = ProductSubcategory::where('status',ACTIVE)->count();
        $totalProduct = Product::whereNull('deleted_at')->count();
        $totalActiveProduct = Product::where('status',ACTIVE)->whereNull('deleted_at')->count();
        $totalDeliveredOrder = Order::where('status',ORDER_DELIVERED)->count();
        $totalCancelledOrder = Order::where('status',ORDER_CANCELLED)->count();
        $totalReturnItems =  ReturnedItem::where('status',2)->count();
        $todayPendingOrder =  Order::where('status',ORDER_PENDING)->whereDate('created_at',date('Y-m-d'))->count();
        $todayAcceptedOrder =  Order::where('status',ORDER_ACCEPTED)->whereDate('created_at',date('Y-m-d'))->count();
        $todayDeliveredOrder =  Order::where('status',ORDER_DELIVERED)->whereDate('created_at',date('Y-m-d'))->count();
        $todayCancelledOrder =  Order::where('status',ORDER_CANCELLED)->whereDate('created_at',date('Y-m-d'))->count();
        $todayReturnItems =  ReturnedItem::where('status',2)->whereDate('created_at',date('Y-m-d'))->count();
        $opendingWithdrawalRequest = Withdrawal::where('status',0)->count();
        $pendingReturnRequest =  ReturnedItem::where('status',0)->count();

        return view('admin.dashboard.index',compact(
            'totalCustomer',
            'totalSeller',
            'totalDeller',
            'totalAgent',
            'totalDeliveryHub',
            'totalCategory',
            'totalSubCategory',
            'totalProduct',
            'totalActiveProduct',
            'totalDeliveredOrder',
            'totalCancelledOrder',
            'totalReturnItems',
            'todayPendingOrder',
            'todayAcceptedOrder',
            'todayDeliveredOrder',
            'todayCancelledOrder',
            'todayReturnItems',
            'opendingWithdrawalRequest',
            'pendingReturnRequest',
        ));
    }
}
