<?php
namespace App\Http\Controllers\admin;
use App\Enums\Constant;
use App\Enums\Image;
use App\Http\Requests\CouponRequest;
use App\Models\Coupon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;

class CouponController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Coupon();
    }
    public function create()
    {
        return view("admin.coupon.store");
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = Coupon::orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.coupon.list", compact("data"));
    }
    public function edit($id)
    {
        $data = Coupon::where("id", $id)->first();
        return view("admin.coupon.store", compact("data"));
    }
    public function view($id)
    {
        $data = Coupon::where("id", $id)->first();
        return view("admin.coupon.view", compact("data"));
    }

    public function store(CouponRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "coupon_name" => $request->coupon_name,
                "coupon_code" => $request->coupon_code,
                "amount_type" => $request->amount_type,
                "amount" => $request->amount,
                "start_date"=>$request->start_date,
                "end_Date"=>$request->end_date,
                "minimum_order_amount" => $request->minimum_order_amount,
            ];
            if ($request->has("id")) {
                Coupon::where("id", $request->id)->update($data);
                $text = "updated";
            } else {
                Coupon::insert($data);
                $text = "created";
            }
            DB::commit();
            return redirect()
                ->back()
                ->with("success", "coupon has been " . $text . " successfully");
        } catch (\Exception $e) {
            DB::rollback();
            Log::error("Coupon -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Coupon::where("id", $id)->update(["deleted_at" => Carbon::now()]);
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
