<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\BrandRequest;
use App\Http\Requests\SizesRequest;
use App\Models\Brands;
use App\Models\Sizes;
use App\Http\Controllers\Controller;
use App\Models\Company;
use Illuminate\Support\Facades\Log;
use DB;

class BrandController extends Controller
{

    public function create()
    {
        $listData = Brands::get();
        $companies = Company::get();
        return view("admin.brand.store", compact("listData","companies"));
    }

    public function edit($id)
    {
        $data = Brands::where("id", $id)->first();
        $listData = Brands::with('company')->get();
        $companies = Company::get();
        return view("admin.brand.store", compact("data", "listData","companies"));
    }

    public function store(BrandRequest $request)
    {
        DB::beginTransaction();
        try {
            if(!is_numeric($request->company)){
                $companyId = Company::insertGetId(['name'=>$request->company]);
            }else{
                $companyId = $request->company;
            }

            $data = ["brand_name_en" => $request->brand_name_en,"brand_name_bn"=>$request->brand_name_bn,'company_id'=>$companyId,'status'=>1];
            Brands::updateOrCreate(['id'=>$request->id],$data);
            DB::commit();
            return redirect()->route('product-brand.create')->with("success", "Brand data saved successfully");
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Brand -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Brands::find($id)->delete();
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
