<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function loginForm(){
        return view('admin.auth.login');
    }


    public function login(Request $request){
        //add role when we will have different types of subdomain
        $auth = Auth::guard('admin')->attempt(['email'=>$request->email,'password'=>$request->password,'status'=>ACTIVE]);
        if($auth){
            toastr()->success('Welcome to the deller panel');
            return redirect()->route('admin.dashboard');
        }else{
            toastr()->error('Sorry ! invalid email or password');
            return redirect()->back();
        }
    }

    public function logout(){
        auth('user')->logout();
        return redirect()->route('auth.login.form');
    }
}
