<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\FlashWalletWithdrawRequest;
use App\Models\AdminWallet;
use App\Models\ComissionWalletHistory;
use App\Models\FlashWalletHistory;
use App\Models\User;
use App\Services\WalletService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminWalletController extends Controller
{
    public function transaction($type){
        $histories = ComissionWalletHistory::with('receivedForm')->where('type',$type)->where('user_id',1)->where('transaction_type',1)->orderByDesc('id')->paginate(10);
        $total = WalletService::getAdminWalletTotal($type);
        return view('admin.admin-wallet.transaction',compact('histories','total'));
    }

    public function withdrawal($type){
        $histories = ComissionWalletHistory::with('receivedForm')->where('type',$type)->where('user_id',1)->where('transaction_type',WITHDRAWAL)->orderByDesc('id')->paginate(10);
        $total = WalletService::getAdminWalletTotal($type);
        return view('admin.admin-wallet.transaction',compact('histories','total'));
    }

    public function withdrawAmount($type,FlashWalletWithdrawRequest $adminWalletWithdrawRequest){
        DB::beginTransaction();
        try{
            $user = User::where('id',1)->first();
            $fieldName = flashWalletTypes()[$type];

            $adminWallet = AdminWallet::first();
            if($user->comission_wallet < $adminWallet[$fieldName]){
                toastr()->error('You don\'t have enough balance');
                return redirect()->back();
            }

            $adminWallet->decrement($fieldName,$adminWalletWithdrawRequest->amount);
            $user->decrement('comission_wallet',$adminWalletWithdrawRequest->amount);

            ComissionWalletHistory::create([
                'user_id'=>1,
                'transaction_type'=>WITHDRAWAL,
                'amount'=>-$adminWalletWithdrawRequest->amount,
                'type'=>$type,
                'message'=>formatAmount($adminWalletWithdrawRequest->amount).' Has been withdrawn',
                'current_balance'=>$user->comission_wallet
            ]);

            DB::commit();

            return redirect()->route('admin.admin-wallet.withdrawal',['type'=>$type]);
        }catch(\Exception $e){
            DB::rollBack();
            toastr()->error($e->getMessage());
            return redirect()->back();
        }
    }

}
